<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exsl="http://exslt.org/common">
	
	<!-- Creates [DiagramName].html file -->
	<xsl:template name="diagramdoc">
		<xsl:param name="package"></xsl:param>
		<xsl:param name="packagePath"/>
		
		<!-- Print Diagram Heading-->
		<!--xsl:variable name="diagramName" select="@name"/-->
		<xsl:variable name="diagramName">
			<xsl:call-template name="diagramFilename">
				<xsl:with-param name="diagram" select="."/>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:variable name="prevPrefix">
			<xsl:call-template name="SetFilePrefix">
				<xsl:with-param name="path" select="concat($outdir, '/', $packagePath, '/', $diagramName)"/>
			</xsl:call-template>
		</xsl:variable>
		<exsl:document href="file:///{$outdir}/{$packagePath}/{$diagramName}">
			<html>
			<head>
			<xsl:call-template name="ImportCSS"/>
			<title>
			<xsl:value-of select="$title_param"></xsl:value-of>
			</title>
			<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
			<xsl:call-template name="ImgLoaderScript"/>
			</head>

			<!-- NAVBAR -->
			<xsl:if test="$navbar_param">
				<xsl:call-template name="DiagramNavBar">
					<xsl:with-param name="diagram" select="current()"></xsl:with-param>
					<xsl:with-param name="header" select="'true'"></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<hr/>

			<h2>
			<font size="-1"><xsl:value-of select="$package/@name"></xsl:value-of></font>
			<br/>
				<xsl:value-of select="@metaclass"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="@name"/>
			</h2>

			<!-- Print diagram properties {class_util.xsl}-->
			<xsl:call-template name="printProperties">
				<xsl:with-param name="element" select="current()"></xsl:with-param>
				<xsl:with-param name="nodeset" select="Property"></xsl:with-param>
				<xsl:with-param name="property-names" select="Property/@name"></xsl:with-param>			
			</xsl:call-template>

			<!-- Print Elements Summary {design_util.xsl}-->
			<xsl:variable name="link_metaclasses" select="key('links-metaclasses','all')"/>
			<xsl:call-template name="designElementsSummary">
				<xsl:with-param name="diagram" select="current()"></xsl:with-param>
				<xsl:with-param name="nodeset" select="DiagramReference"></xsl:with-param>
				<xsl:with-param name="metaclasses" select="DiagramReference[not(@metaclass=$link_metaclasses)]/@metaclass"></xsl:with-param>			
			</xsl:call-template>			
			
			<xsl:if test="$viewType='diagram'">
				<xsl:variable name="detailTitle">
					<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'diagram_elements_detail'"/></xsl:call-template>
				</xsl:variable>
			
				<!-- Print Elements Detail {design_util.xsl}-->
				<xsl:call-template name="designElementsDetail">
					<xsl:with-param name="title" select="$detailTitle"></xsl:with-param>
					<xsl:with-param name="nodeSet" select="self::Diagram//DiagramReference"></xsl:with-param>
				</xsl:call-template>			
			</xsl:if>
			<!-- NAVBAR -->
			<hr/>
			<xsl:if test="$navbar_param">
				<xsl:call-template name="DiagramNavBar">
					<xsl:with-param name="diagram" select="current()"></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<br/>
			<p/>
			<xsl:value-of select="$bottom_param"></xsl:value-of>
					
			</html>					
		</exsl:document>
		<xsl:variable name="tmp">
			<xsl:call-template name="ResetPrefix">
				<xsl:with-param name="prefix" select="$prevPrefix"/>
			</xsl:call-template>
		</xsl:variable>
		
	</xsl:template>
	
	
	<!-- Prints Elements Summary Table-->
	<xsl:template name="designElementsSummary">
		<xsl:param name="diagram"></xsl:param>
		<xsl:param name="nodeset"></xsl:param>
		<xsl:param name="metaclasses"></xsl:param>
	
		<xsl:variable name="first" select="$metaclasses[1]"></xsl:variable>
		<xsl:if test="$first">
		<xsl:variable name="shapeType" select="string($first)"></xsl:variable>
		<xsl:variable name="codeSummary">
			<xsl:choose>
				<xsl:when test="$shapeType = 'Package'">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Package_Summary'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$shapeType = 'Class'">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Class_Summary'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$shapeType = 'Interface'">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Interface_Summary'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$shapeType = 'Struct'">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Struct_Summary'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$shapeType = 'Delegate'">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Delegate_Summary'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$shapeType = 'Enum'">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Enum_Summary'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$shapeType = 'Module'">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Module_Summary'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'summary'"/>
						<xsl:with-param name="p1" select="$shapeType"/>
					</xsl:call-template>				
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:call-template name="createDesignElementSummaryTable">
				<xsl:with-param name="title" select="$codeSummary"/>
				<xsl:with-param name="nodeSet" select="$diagram/DiagramReference[@metaclass=$shapeType]"/>
		</xsl:call-template>

		<xsl:call-template name="designElementsSummary">
			<xsl:with-param name="diagram" select="$diagram"></xsl:with-param>
			<xsl:with-param name="nodeset" select="$nodeset"></xsl:with-param>
			<xsl:with-param name="metaclasses" select="$metaclasses[not(string($shapeType)=string(.))]"></xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

	
	
</xsl:stylesheet>
